#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <sysutils.hpp>

#define HID_USAGE_PAGE_BUTTON      ((USAGE) 0x09)
#define HID_USAGE_PAGE_GENERIC     ((USAGE) 0x01) //hidusage.h
#define HID_USAGE_GENERIC_JOYSTICK ((USAGE) 0x04)


using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//typedef unsigned int NTSTATUS;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
HIDP_CAPS capabilities;

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

HANDLE  hidDeviceObject;

//---------------------------------------------------------
typedef enum _HIDP_REPORT_TYPE { //hidpi.h
   HidP_Input,
   HidP_Output,
   HidP_Feature
}  HIDP_REPORT_TYPE;
//---------------------------------------------------------
typedef struct _HIDP_BUTTON_CAPS {
   USAGE  UsagePage;
   UCHAR  ReportID;
   BOOLEAN  IsAlias;
   USHORT  BitField;
   USHORT  LinkCollection;
   USAGE  LinkUsage;
   USAGE  LinkUsagePage;
   BOOLEAN  IsRange;
   BOOLEAN  IsStringRange;
   BOOLEAN  IsDesignatorRange;
   BOOLEAN  IsAbsolute;
   ULONG  Reserved[10];
     union {
       struct {
         USAGE  UsageMin, UsageMax;
         USHORT  StringMin, StringMax;
         USHORT  DesignatorMin, DesignatorMax;
         USHORT  DataIndexMin, DataIndexMax;
        } Range;
       struct {
         USAGE  Usage, Reserved1;
         USHORT  StringIndex, Reserved2;
         USHORT  DesignatorIndex, Reserved3;
         USHORT  DataIndex, Reserved4;
       } NotRange;
     };
} HIDP_BUTTON_CAPS, *PHIDP_BUTTON_CAPS;
//---------------------------------------------------------
int main()
{
  unsigned int (__stdcall *HidP_GetButtonCaps)(IN HIDP_REPORT_TYPE  ReportType,
               OUT PHIDP_BUTTON_CAPS  ButtonCaps,IN OUT PULONG  ButtonCapsLength,
               IN PHIDP_PREPARSED_DATA  PreparsedData);

  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

  long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);

  bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                      OUT PHIDP_PREPARSED_DATA *PreparsedData);

  bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);


  hHidLib = LoadLibrary("HID.DLL");
  if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

  (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
  (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
  (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
  (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");
  (FARPROC&) HidP_GetButtonCaps=GetProcAddress(hHidLib,
                                             "HidP_GetButtonCaps");


   if (!HidD_GetHidGuid || !HidP_GetCaps || !HidD_GetPreparsedData
       || !HidP_GetButtonCaps || !HidD_FreePreparsedData){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
           cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
           hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ, FILE_SHARE_READ,
                                     NULL,OPEN_EXISTING,0,NULL);
           if(hidDeviceObject==INVALID_HANDLE_VALUE)
             displayError("Nie mona otworzy urzdzenia do transmisji");
             else
               break;
       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);

   if(HidD_GetPreparsedData(hidDeviceObject, &preparsedData)){
      HidP_GetCaps(preparsedData, &capabilities);


      PULONG  buttonCapsLength;
      HIDP_BUTTON_CAPS *buttonCaps = new \
      HIDP_BUTTON_CAPS[capabilities.NumberInputButtonCaps];

      HidP_GetButtonCaps(HidP_Input, buttonCaps, buttonCapsLength, preparsedData);

      for(USHORT i = 0; i<capabilities.NumberInputButtonCaps;i++) {
         printf("ButtonCaps[%d].UsagePage %x\n", i, buttonCaps[i].UsagePage);
         printf("ButtonCaps[%d].ReportID= x%x\n", i, buttonCaps[i].ReportID);
         printf("ButtonCaps[%d].IsAlias= x%x\n", i, buttonCaps[i].IsAlias);
         printf("ButtonCaps[%d].BitField= %d\n", i, buttonCaps[i].BitField);
         printf("ButtonCaps[%d].LinkCollection= x%x\n", i,
                                                buttonCaps[i].LinkCollection);
         printf("ButtonCaps[%d].LinkUsage= x%x\n", i, buttonCaps[i].LinkUsage);
         printf("ButtonCaps[%d].LinkUsagePage= 0x%x\n", i,
                                                 buttonCaps[i].LinkUsagePage);
         printf("ButtonCaps[%d].IsRange= %d\n\n", i, buttonCaps[i].IsRange);

         if(buttonCaps[i].IsRange) {
            printf("Usages min, max %d..%d\n\n", buttonCaps[i].Range.UsageMin,
                   buttonCaps[i].Range.UsageMax);
            printf("Data index min, max %d..%d\n\n", buttonCaps[i].Range.DataIndexMin,
                   buttonCaps[i].Range.DataIndexMax);

            switch (buttonCaps[i].UsagePage) {
              case HID_USAGE_PAGE_BUTTON:
                printf("\Usage Page -> Button Page\n");
              break;
              /*...*/
              default :
                printf("...");
            }
            switch (buttonCaps[i].LinkUsage) {
              case HID_USAGE_GENERIC_JOYSTICK:
                printf("\Link Usage -> Generic Joystick Page\n");
              break;
              /*...*/
              default :
                printf("...");
            }
            switch (buttonCaps[i].LinkUsagePage) {
              case HID_USAGE_PAGE_GENERIC:
                printf("\Link Usage Page -> Generic Desktop Page\n");
              break;
              /*...*/
              default :
                printf("...");
            }
         }
         else
           printf("Not Range Usage%d\n\n", buttonCaps[i].NotRange.Usage);
      }
      releaseMemory(buttonCaps);
   }
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

